.syntax unified

.equ L152,1
.include "../Core/src/regs.s"

.global mainasm

mainasm:



main:
ldr R0,=rcc	//Taktversorgung für GPIO
ldr R1,[R0,RCC_AHBENR]
orr R1,Bit2+Bit1+Bit0
str R1,[R0,RCC_AHBENR]
//GPIOC 7..0 als Ausgänge
ldr R1,=GPIOC
ldr R2,[R1,MODER]
mov R3,0b0101010101010101
orr R2,R3
str R2,[R1,MODER]
//**********************************************************
// Timer TIM6 initialisieren
//*********************************************************
//TIM2, TIM6 und TIM7 mit Takt versorgen
ldr 	R0,=rcc
ldr 	R1,[R0,RCC_APB1ENR]
orr 	R1,0b110001   			//0bTIM7,TIM6,000,TIM2
str 	R1,[R0,RCC_APB1ENR]
ldr 	R3,=TIM2	//Timerauswahl TIM2, TIM6, TIM7
mov 	R1,#31999	//Prescalerwert 31999 = 1 ms
str 	R1,[R3,PSC]
mov		R1,#499		//Autoreloadwert 500ms
str		R1,[R3,ARR]
mov		R1,#0
str 	R1,[R3,CNT] //Zähler bei 0 starten
str 	R1,[R3,SR]	//Update Interrupt flag UIF zurücksetzen
mov 	R1,#1
str 	R1,[R3,CR1] //Timer starten (CEN=1)
//Timerinitialisierung fertig
ldr		R1,=GPIOC
schleife:				//Sprungmarke
ldr 	R2,[R3,SR]	//Statusregister einlesen
tst 	R2,Bit0		//Bit0 = Update Interrupt Flag UIF = Überlaufbit
beq		schleife	//nicht gesetzt dann Schleife
mov 	R2,#0		//UIF zurücksetzen
str 	R2,[R3,SR]
ldrb 	R2,[R1,ODR]	//Bit1 im ODR umschalten (blinken)
eor 	R2,Bit1
strb 	R2,[R1,ODR]
b		schleife		//branch = Sprung = Fortsetzen bei Sprungmarke (label) schleife:
.end
